﻿//***************************************************************************************
// Ssao.h Frank Luna (C) 2011 Wszelkie prawa zastrzeżone.
//   
// Klasa zawiera dane i metody potrzebne do przeprowadzenia okluzji otoczenia przestrzeni ekranu.
//***************************************************************************************

#ifndef SSAO_H
#define SSAO_H

#include "d3dUtil.h"
 
 // Czy powinniśmy renderować okluzję otoczenia w dwukrotnie niższej rozdzielczości?
 
class Camera;

class Ssao
{
public:
	Ssao(ID3D11Device* device, ID3D11DeviceContext* dc, int width, int height, float fovy, float farZ);
	~Ssao();

	ID3D11ShaderResourceView* NormalDepthSRV();
	ID3D11ShaderResourceView* AmbientSRV();

	///<summary>
	/// Wywołaj przy zmianie rozmiaru bufora tylnego.  
	///</summary>
	void OnSize(int width, int height, float fovy, float farZ);
 
	///<summary>
	/// Zmienia cel renderowania na cel renderowania NormalDepth. Przekaż 
	/// główny bufor głębokości jako bufor głębokości używany przy renderowaniu
	/// do mapy NormalDepth. Ten przebieg ustala głębokość sceny, dzięki czemu
	/// w kolejnym scena nie jest przerysowywana.
	///</summary>
	void SetNormalDepthRenderTarget(ID3D11DepthStencilView* dsv);

	///<summary>
	/// Zmienia cel renderowania na cel renderowania Ambient i rysuje pełnoekranowy
	/// czworokąt, aby shader pikseli mógł obliczyć mapę AmbientMap. Główny bufor
	/// głębokości pozostaje powiązany z potokiem, ale zapis i odczyt do niego są
	/// wyłączone, ponieważ bufor głębokości nie jest potrzebny przy obliczaniu mapy Ambient.
	///</summary>
	void ComputeSsao(const Camera& camera);

	///<summary>
	/// Rozmywa mapę okluzji otoczenia, aby wygładzić szum powstały na skutek
	/// uwzględnienia tylko kilku losowych próbek na piksel. Używamy rozmycia 
	/// z zachowaniem krawędzi, aby nie rozmywać nieciągłych obszarów (chcemy zachować krawędzie).
	///</summary>
	void BlurAmbientMap(int blurCount);

private:
	Ssao(const Ssao& rhs);
	Ssao& operator=(const Ssao& rhs);

	void BlurAmbientMap(ID3D11ShaderResourceView* inputSRV, ID3D11RenderTargetView* outputRTV, bool horzBlur);

	void BuildFrustumFarCorners(float fovy, float farZ);

	void BuildFullScreenQuad();

	void BuildTextureViews();
	void ReleaseTextureViews();

	void BuildRandomVectorTexture();

	void BuildOffsetVectors();

	void DrawFullScreenQuad();

private:
	ID3D11Device* md3dDevice;
	ID3D11DeviceContext* mDC;

	ID3D11Buffer* mScreenQuadVB;
	ID3D11Buffer* mScreenQuadIB;

	ID3D11ShaderResourceView* mRandomVectorSRV;

	ID3D11RenderTargetView* mNormalDepthRTV;
	ID3D11ShaderResourceView* mNormalDepthSRV;

	// Potrzebne dwa dla schematu ping-pong podczas rozmywania.
	ID3D11RenderTargetView* mAmbientRTV0;
	ID3D11ShaderResourceView* mAmbientSRV0;

	ID3D11RenderTargetView* mAmbientRTV1;
	ID3D11ShaderResourceView* mAmbientSRV1;


	UINT mRenderTargetWidth;
	UINT mRenderTargetHeight;

	XMFLOAT4 mFrustumFarCorner[4];

	XMFLOAT4 mOffsets[14];

	D3D11_VIEWPORT mAmbientMapViewport;
};

#endif // SSAO_H